#include <bits/stdc++.h>
using namespace std;

const int N = 3005;
const int INF = 987654321;

int a[2 * N];

vector<int> graph[N];
map<int, bool> isL[2 * N];
map<int, bool> isR[2 * N];

int l[N];
int r[N];

int dist[N][N];
bool visited[N];

int n, q;

void printGraph(){
    for(int i = 0; i < n; ++i){
        cout << i << ": ";
        for(auto u : graph[i]){
            cout << u << ", ";
        }
        cout << "\n";
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    for(int i = 0; i < N; ++i){
        l[i] = -1;
        r[i] = -1;
    }

    cin >> n >> q;
    for(int i = 0; i < 2 * n; ++i){
        cin >> a[i];
        a[i]--;
    }


    for(int i = 0; i < 2 * n; ++i){
        if(l[a[i]] == -1)
            l[a[i]] = i;
        else
            r[a[i]] = i;

        if(i)
            isL[i] = isL[i - 1];
        isL[i][a[i]] = true;
    }

    for(int i = 2 * n - 1; i >= 0; --i){
        if(i != 2 * n - 1)
            isR[i] = isR[i + 1];
        isR[i][a[i]] = true;
    }


    for(int i = 0; i < n; ++i){
        for(int j = 0; j < n; ++j){
            if(i == j)
                continue;
            if(isL[l[i]][j] && isR[r[i]][j]){
                graph[i].push_back(j);
                graph[j].push_back(i);
            }
        }
    }

    //printGraph();

    for(int i = 0; i < 3005; ++i){
        for(int j = 0; j < 3005; ++j){
            dist[i][j] = INF;
        }
    }

    for(int curSource = 0; curSource < n; curSource++){
        for(int i = 0; i < 3005; ++i){
            visited[i] = false;
        }

        dist[curSource][curSource] = 0;

        queue<pair<int, int>> qu;
        qu.push({curSource, 0});
        while(!qu.empty()){
            pair<int, int> v = qu.front();
            qu.pop();
            dist[curSource][v.first] = v.second;
            dist[v.first][curSource] = v.second;

            for(auto c : graph[v.first]){
                if(!visited[c]){
                    visited[c] = true;
                    qu.push({c, v.second + 1});
                }
            }
        }
    }


    while(q--){
        int v, u;
        cin >> v >> u;
        v--;
        u--;
        if(dist[v][u] == INF){
            cout << "-1\n";
        }else{
            cout << dist[v][u] << "\n";
        }
    }
    return 0;
}